	function PLOT_ATT_S(W, Att)
 
	% 	Plots the attenuaton of an analog filter
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-05-07
	% 	Modified by: 	 	
	%	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
 
	ymax = 10*floor(max(Att)/10) + 10;
	plot(W, Att,'linewidth',lw); 
	axis([min(W) max(W) 0 ymax])
	ylabel('{\itA}({\it\omega})  [dB]','FontName', fn,'FontSize',fs);	
	xlabel('{\it\omega}  [rad/s]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	grid on;
